﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AdmZatrudnienieZalaczniki.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.AdmZatrudnienieZalaczniki" %>

<%@ Register TagPrefix="myParam" Namespace="KOLKaP_WEB.KOLKaP.Class" Assembly="KOLKaP_WEB" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title>Wniosek o zatrudnienie - załączniki</title>
  <link href="../Web.css?3" type="text/css" rel="stylesheet" />
  <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
  <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
  <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>

  <script type="text/javascript">
    $(function () {

      $("#btnDodajZalacznik").button({ icons: { primary: 'ui-icon-plusthick' } });
      $("#btnDodajZalacznikOk").button({ icons: { primary: 'ui-icon-plusthick' } });
      $("#btnDodajZalacznikAnuluj").button({ icons: { primary: 'ui-icon-cancel' } });

    });
  </script>
</head>
<body class="Table" style="margin-left: 0px; margin-right: 0px; margin-top: 0px; background-color: #c7c7c7">
  <form id="form1" runat="server">
    <div>
      <div style="background-color:white; padding-top: 5px;">
        <asp:Button ID="btnDaneOgolne" runat="server" Text="Dane ogólne" CssClass="aspButton" Width="105px" Height="22px" BorderStyle="None" BorderColor="Gainsboro" BackColor="Gainsboro" OnClick="btnDaneOgolne_Click"></asp:Button>
        <asp:Button ID="btnPrawa" runat="server" Text="Prawa" CssClass="aspButton" Width="105px" Height="22px" BorderStyle="None" BorderColor="Gainsboro" BackColor="Gainsboro" OnClick="btnPrawa_Click"></asp:Button>
        <asp:Button ID="btnZalaczniki" runat="server" Text="Załączniki" CssClass="aspButton" Width="105px" Height="22px" BorderStyle="None" BorderColor="Gainsboro" BackColor="Gainsboro"></asp:Button>
      </div>
      <div>
        <div>
          <asp:Label ID="lblError" runat="server"></asp:Label>
        </div>
        <!-- załączniki -->
        <div id="divZalaczniki" runat="server">
          <div>
            <div style="margin-top:13px;">
              <div>
                <asp:LinkButton ID="btnDodajZalacznik" runat="server" Text="Dodaj załącznik" CssClass="Button"
                  Enabled="False" OnClick="btnDodajZalacznik_Click"></asp:LinkButton>
              </div>
              <div id="divDodajZalacznik" style="display: none; width: 550px" runat="server">
                <div style="height: 10px">
                  &nbsp;
                </div>
                <div style="color: Blue; font-size: 10pt">
                  Wybierz plik który ma zostać załączony do specyfikacji
                </div>
                <asp:FileUpload ID="fuKlucz" runat="server" Style="width: 500px" />
                <div>
                  <asp:LinkButton ID="btnDodajZalacznikOk" runat="server" Width="90px" Text="Dodaj"
                    CssClass="Button" OnClick="btnDodajZalacznikOk_Click"></asp:LinkButton>
                  <asp:LinkButton ID="btnDodajZalacznikAnuluj" runat="server" Width="90px" Text="Anuluj"
                    CssClass="Button" OnClick="btnDodajZalacznikAnuluj_Click"></asp:LinkButton>
                </div>
              </div>
            </div>
            <div>
              <asp:GridView ID="gvAkZatrudnienieZalaczniki" runat="server" CssClass="aspGrid" AutoGenerateColumns="False"
                DataKeyNames="ID_ZALACZNIKA,ZALACZNIK_NAZWA,USUN_ENABLED" DataSourceID="sdsAkZatrudnienieZalaczniki"
                AllowSorting="True" Style="width: 80%" OnRowCommand="gvAkZatrudnienieZalaczniki_RowCommand" OnRowDataBound="gvAkZatrudnienieZalaczniki_RowDataBound">
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
                <Columns>
                  <asp:BoundField DataField="ZALACZNIK_NAZWA" HeaderText="Nazwa pliku" SortExpression="ZALACZNIK_NAZWA" />
                  <asp:BoundField DataField="DATA_UTWORZENIA" DataFormatString="{0:yyyy-MM-dd HH:mm}" HeaderText="Data dodania" SortExpression="DATA_UTWORZENIA" />
                  <asp:BoundField DataField="UTWORZYL" HeaderText="Dodał" SortExpression="UTWORZYL" />
                  <asp:TemplateField ShowHeader="False">
                    <ItemTemplate>
                      &nbsp;<asp:ImageButton ID="ibUsunZalacznik" runat="server" AlternateText="Usuń załącznik"
                        ToolTip="Usuń załącznik" CommandName="USUN" ImageAlign="Middle" ImageUrl="~/img/usun.png" />
                    </ItemTemplate>
                    <ItemStyle Width="24px" />
                  </asp:TemplateField>
                  <asp:TemplateField ShowHeader="False">
                    <ItemTemplate>
                      <asp:ImageButton ID="ibPodgladZalacznik" runat="server" AlternateText="Podgląd załącznika"
                        ToolTip="Podgląd załącznika" CommandName="PODGLAD" ImageAlign="Middle" ImageUrl="~/img/przegladaj.png" />
                    </ItemTemplate>
                    <ItemStyle Width="24px" HorizontalAlign="Center" VerticalAlign="Middle" />
                  </asp:TemplateField>
                </Columns>
              </asp:GridView>
              <asp:SqlDataSource ID="sdsAkZatrudnienieZalaczniki" runat="server" OnSelected="sdsAkZatrudnienieZalaczniki_Selected"
                ProviderName="System.Data.SqlClient" SelectCommand="AK_ZATRUDNIENIE_ZALACZNIKI_LIST"
                SelectCommandType="StoredProcedure" CancelSelectOnNullParameter="False">
                <SelectParameters>
                  <myParam:ZatrudnienieSdsParameter Name="P_ID_WNIOSKU" Type="String" ZatrudnienieSdsKey="ID_WNIOSKU" />
                  <asp:Parameter DefaultValue="T" Name="P_BEZ_ZALACZNIKA" />
                </SelectParameters>
              </asp:SqlDataSource>
            </div>
          </div>
        </div>
        <!-- koniec załączniki -->
      </div>
    </div>
  </form>
</body>
</html>
